﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using FDK;

namespace StrokeStyleT
{
	class CStageCAUTION : CActivity
	{
		protected const long n間隔ms = 2000;
		protected enum EフェーズID { フェードイン, 通常, フェードアウト };
		protected Cスレッドセーフ<EフェーズID> eフェーズID = new Cスレッドセーフ<EフェーズID>( EフェーズID.フェードイン );

		public CStageCAUTION()
		{
			this.list子Activities.Add( this.Actフェードイン = new CMActフェードイン・透明度( 4 ) );
			this.list子Activities.Add( this.Actフェードアウト = new CMActフェードアウト・透明度( 4 ) );
		}

		public override void On活性化()
		{
			if( this.b活性化してる )
				return;

			this.Timer = new CTimer( CTimer.E種別.MultiMedia );

			base.On活性化();
		}
		public override void On非活性化()
		{
			if( this.b活性化してない )
				return;

			Global.tDisposeする( this.Timer );

			base.On非活性化();
		}

		public override void Onリソースの作成( IntPtr hDevice )
		{
			// まだユーザはログインしていない。
			this.tx背景 = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenCaution.jpg" ), D3DFormat.A8R8G8B8, false );
			this.tx黒板 = new CTexture( hDevice, Folder.stgテーマファイル( @"Black 64x64.png" ), D3DFormat.A8R8G8B8, false );

			base.Onリソースの作成();
		}
		public override void Onリソースの解放()
		{
			Global.tDisposeする( this.tx背景 );
			Global.tDisposeする( this.tx黒板 );

			base.Onリソースの解放();
		}

		public override int On進行()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				throw new Exception( "活性化していません。" );
			//-----------------
			#endregion

			if( this.b初めての進行 )
			{
				this.eフェーズID.Set( EフェーズID.フェードイン );
				this.Actフェードイン.t開始();
				this.b初めての進行 = false;
			}

			this.Timer.t更新();

			switch( this.eフェーズID.Get() )
			{
				case EフェーズID.フェードイン:
					this.Actフェードイン.On進行();
					if( this.Timer.n現在時刻ms > n間隔ms )
						this.eフェーズID.Set( EフェーズID.通常 );
					break;

				case EフェーズID.通常:
					if( this.Timer.n現在時刻ms > n間隔ms * 2 )
					{
						this.eフェーズID.Set( EフェーズID.フェードアウト );
						this.Actフェードアウト.t開始();
					}
					break;

				case EフェーズID.フェードアウト:
					this.Actフェードアウト.On進行();
					if( this.Timer.n現在時刻ms > n間隔ms * 3 )
						return (int) E進行結果.完了;
					break;
			}

			#region [ ESC → 終了 ]
			//-----------------
			if( Global.Input.Input管理.Keyboard.bキーが押された( Key.Escape ) )
				Global.App.bアプリケーションを終了する.Set( true );
			//-----------------
			#endregion

			return (int) E進行結果.継続;
		}
		public override void On描画( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				throw new Exception( "活性化していません。" );
			//-----------------
			#endregion

			this.tx背景.t2D描画( hDevice, 0, 0 );

			switch( this.eフェーズID.Get() )
			{
				case EフェーズID.フェードイン:
					this.Actフェードイン.On描画( hDevice, this.tx黒板, Global.App.Direct3D );
					break;

				case EフェーズID.通常:
					break;

				case EフェーズID.フェードアウト:
					this.Actフェードアウト.On描画( hDevice, this.tx黒板, Global.App.Direct3D );
					break;
			}
		}

		protected CMActフェードイン・透明度 Actフェードイン;
		protected CMActフェードアウト・透明度 Actフェードアウト;
		protected CTexture tx背景 = null;
		protected CTexture tx黒板 = null;
		protected CTimer Timer = null;
	}
}
